customElements.define('kiwi-switch',
    class extends HTMLElement {
  
    static observedAttributes = ["value"];
  
    constructor() {
      super();
  
      this.route = this.getAttribute('route');
      this.value = this.getAttribute('checked');
      this.label = this.getAttribute('label');
  
      this.template = `
          <label>
            <input type="checkbox" role="switch" ${this.value === "true" ? 'checked' : '' }>
            ${this.label}
          </label>`;
  
      this.insertAdjacentHTML('afterbegin', this.template);
      this.switchElement = this.querySelector('input');
      this.switchElement.addEventListener('change', this);
    }
  
    handleEvent(event) {
      this[`on${event.type}`](event);
    }
  
    onchange(event) {
      const pad = this.id.split('-').slice(0, -1)[0];
      const param = this.id.split('-').slice(-1)[0];
      fetchData(`${this.route}/?pad=${pad}&param=${param}&value=${event.target.checked ? 1 : 0}`);
    }
  
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue == newValue) return;
      this.switchElement.checked = newValue;
    }
  });
  