customElements.define('kiwi-midi',
  class extends HTMLElement {

  static observedAttributes = ["value"];

  constructor() {
    super();

    this.route = this.getAttribute('route');
    this.value = Number(this.getAttribute('value'));
    this.label = this.getAttribute('label');

    this.template = `
      <label id="${this.id}">
        ${this.label}
        <select name="${this.id}">
          <optgroup label="Drum Kit">
          <option value="36">Kick Drum</option>
          <option value="38">Snare Drum</option>
          <option value="42">Hi-Hat Closed</option>
          <option value="46">Hi-Hat Open</option>
          <option value="41">Tom 1</option>
          <option value="43">Tom 2</option>
          <option value="45">Tom 3</option>
          <option value="48">Floor Tom</option>
          <option value="49">Crash Cymbal 1</option>
          <option value="57">Crash Cymbal 2</option>
          <option value="51">Ride Cymbal</option>
          <option value="52">China Cymbal</option>
          <option value="53">Splash Cymbal</option>
          <optgroup label="Percussion">
          <option value="39">Clap</option>
          <option value="54">Tambourine</option>
          <option value="56">Cowbell</option>
          <option value="70">Maracas</option>
          <option value="69">Cabasa</option>
          <option value="71">Whistle</option>
          <option value="73">Guiro</option>
          <option value="58">Vibraslap</option>
          <option value="64">Conga low</option>
          <option value="65">Conga mid</option>
          <option value="67">Conga high</option>
          <option value="60">Bongo low</option>
          <option value="61">Bongo high</option>
        </select>
      </label>
    `;

    this.insertAdjacentHTML('afterbegin', this.template);
    this.selectElement = this.querySelector('select');
    this.selectElement.value = this.value;

    this.selectElement.addEventListener('change', this);
  }

  handleEvent(event) {
    this[`on${event.type}`](event);
  }

  onchange(event) {
    const pad = this.id.split('-').slice(0, -1)[0];
    const param = this.id.split('-').slice(-1)[0];
    fetchData(`${this.route}/?pad=${pad}&param=${param}&value=${event.target.value}`);
  }

  attributeChangedCallback(name, oldValue, newValue) {
    if (newValue == oldValue) return;
    this.selectElement.value = newValue;
  }
});
